#include "ShaderConstants.fxh"

struct VS_Input {
	float3 position : POSITION;
	float4 color : COLOR;
	float2 uv0 : TEXCOORD_0;
	float2 uv1 : TEXCOORD_1;
#ifdef INSTANCEDSTEREO
	uint instanceID : SV_InstanceID;
#endif
};


struct PS_Input {
	float4 position : SV_Position;
	float3 wpos : WPOS;
	float4 posi : POSI;


#ifndef BYPASS_PIXEL_SHADER
	lpfloat4 color : COLOR;
	snorm float2 uv0 : TEXCOORD_0_FB_MSAA;
	snorm float2 uv1 : TEXCOORD_1_FB_MSAA;
#endif

#ifdef FOG
	float4 fogColor : FOG_COLOR;
#endif
#ifdef GEOMETRY_INSTANCEDSTEREO
	uint instanceID : SV_InstanceID;
#endif
#ifdef VERTEXSHADER_INSTANCEDSTEREO
	uint renTarget_id : SV_RenderTargetArrayIndex;
#endif
};


static const float rA = 1.0;
static const float rB = 1.0;
static const float3 UNIT_Y = float3(0, 1, 0);
static const float DIST_DESATURATION = 56.0 / 255.0; //WARNING this value is also hardcoded in the water color, don'tchange

#include "dect.fxh"
#include "inform/option.txt"

ROOT_SIGNATURE
void main(in VS_Input VSInput, out PS_Input PSInput)
{
#ifndef BYPASS_PIXEL_SHADER
	PSInput.uv0 = VSInput.uv0;
	PSInput.uv1 = VSInput.uv1;
	PSInput.color = VSInput.color;
#endif

#ifdef AS_ENTITY_RENDERER
	#ifdef INSTANCEDSTEREO
		int i = VSInput.instanceID;
		PSInput.position = mul(WORLDVIEWPROJ_STEREO[i], float4(VSInput.position, 1));
	#else
		PSInput.position = mul(WORLDVIEWPROJ, float4(VSInput.position, 1));
	#endif
		float3 worldPos = PSInput.position;
#else
		float3 worldPos = (VSInput.position.xyz * CHUNK_ORIGIN_AND_SCALE.w) + CHUNK_ORIGIN_AND_SCALE.xyz;
	
		// Transform to view space before projection instead of all at once to avoid floating point errors
		// Not required for entities because they are already offset by camera translation before rendering
		// World position here is calculated above and can get huge
	#ifdef INSTANCEDSTEREO
		int i = VSInput.instanceID;
	
		PSInput.position = mul(WORLDVIEW_STEREO[i], float4(worldPos, 1 ));
		PSInput.position = mul(PROJ_STEREO[i], PSInput.position);
	
	#else
		PSInput.position = mul(WORLDVIEW, float4( worldPos, 1 ));
		PSInput.position = mul(PROJ, PSInput.position);
	#endif

#endif
#ifdef GEOMETRY_INSTANCEDSTEREO
		PSInput.instanceID = VSInput.instanceID;
#endif 
#ifdef VERTEXSHADER_INSTANCEDSTEREO
		PSInput.renTarget_id = VSInput.instanceID;
#endif
///// find distance from the camera

#if defined(FOG) || defined(BLEND)
	#ifdef FANCY
		float3 relPos = -worldPos;
		float cameraDepth = length(relPos);
	#else
		float cameraDepth = PSInput.position.z;
	#endif
#endif


float chuva = Rain(FOG_CONTROL);

float4 Po =  float4(VSInput.position, 1.0);
float4 ppa = Po;
float pa = sin((TIME * 0.80) + Po.x + Po.y) * 0.03;
float pac = sin((TIME * 4.0) + Po.x + Po.y) * 0.03;


float3 Og = float3(0.0,0.0,0.0);
float2 T0 = floor(VSInput.uv0.xy * float2(64.0,32.0));


Og.xy += lerp(sin(TIME * 1.2 + Po.x - Po.x + sin(TIME * 1.2 + Po.x )),sin(TIME - Po.x + Po.z + sin(TIME - Po.x )),sin(TIME));
Og.xy += (sin(TIME * 8.0 + Po.z) + sin(TIME * 8.0 + Po.x) * 0.05) * chuva;
Og *= 0.8;
Og *= pow(1.0 - (VSInput.uv0.y * 32.0 - T0.y), 6.0);

#ifdef WAVE_GRASSES
//ender
if(End(FOG_COLOR)){}else{
//nether
if(Nether(FOG_CONTROL)){}else{
// PLANTAS DE VERDE
#ifdef ALPHA_TEST 

if(PSInput.color.a == 0.0){
	PSInput.position.xy += lerp(pa, pac, chuva*VSInput.uv1.y);
}else{
if(PSInput.color.r > PSInput.color.g){}else{
	if(PSInput.color.r > PSInput.color.b){
		//capin altas
		if(PSInput.uv0.y < 0.2){ PSInput.position.xyz += Og*VSInput.uv1.y;
		}
		//short grass
		if(PSInput.uv0.x > 0.5){  if(PSInput.uv0.x > 0.6){
			//green rope plant
			float gr = sin(TIME * 1.5 + Po.x + Po.z + Po.x + Po.z + Po.y) * sin(Po.z) * 0.03;
				   gr += (sin(TIME * 6.0 + Po.x + Po.z + Po.x + Po.z + Po.y) * sin(Po.x) * 0.05) * chuva;
			PSInput.position.x += gr*VSInput.uv1.y;
		 }else{
			PSInput.position.xyz += Og*VSInput.uv1.y;
		}}

		//sugar cane
		if(PSInput.uv0.x < 0.4){ if(PSInput.uv0.y < 0.2){}else{
				float sc = sin(TIME * 1.5 + Po.x + Po.z + Po.x + Po.z + Po.y) * sin(Po.z) * 0.01;
					  sc += (sin(TIME * 6.0 + Po.x + Po.z + Po.x + Po.z + Po.y) * sin(Po.x) * 0.01 ) * chuva;
				PSInput.position.x += sc*VSInput.uv1.y;
			 }}

	}
}}
#endif


// FLORES
#ifdef ALPHA_TEST
if(PSInput.color.a == 0.0){}else{
if(PSInput.color.r > PSInput.color.b){}else{
if(PSInput.uv0.y < 0.2){}else{
if(PSInput.uv0.y > 0.5){}else{
	//batata E FUNGO DE NETHER
	if(PSInput.uv0.x < 0.4){ if(PSInput.uv0.x < 0.25){}else{ PSInput.position.xyz += Og*VSInput.uv1.y;
	}}}
    //flor de amarelo
	if(PSInput.uv0.y < 0.4){if(PSInput.uv0.x < 0.75){}else{ 
		PSInput.position.xyz += Og*VSInput.uv1.y;
	}}
}}}

#endif
}}
#endif
PSInput.wpos = worldPos.xyz;
PSInput.posi = float4(VSInput.position, 1) * CHUNK_ORIGIN_AND_SCALE.w;
///////







	///// apply fog

#ifdef FOG
	float len = cameraDepth / RENDER_DISTANCE;
#ifdef ALLOW_FADE
	len += RENDER_CHUNK_FOG_ALPHA.r;
#endif

	PSInput.fogColor.rgb = FOG_COLOR.rgb;
	PSInput.fogColor.a = clamp((len - FOG_CONTROL.x) / (FOG_CONTROL.y - FOG_CONTROL.x), 0.0, 1.0);

#endif

///// blended layer (mostly water) magic
#ifdef BLEND
	//Mega hack: only things that become opaque are allowed to have vertex-driven transparency in the Blended layer...
	//to fix this we'd need to find more space for a flag in the vertex format. color.a is the only unused part
	bool shouldBecomeOpaqueInTheDistance = VSInput.color.a < 0.95;
	if(shouldBecomeOpaqueInTheDistance) {
		#ifdef FANCY  /////enhance water
			float cameraDist = cameraDepth / FAR_CHUNKS_DISTANCE;
		#else
			float3 relPos = -worldPos.xyz;
			float camDist = length(relPos);
			float cameraDist = camDist / FAR_CHUNKS_DISTANCE;
		#endif //FANCY
		
		float alphaFadeOut = clamp(cameraDist, 0.0, 1.0);
		PSInput.color.a = lerp(VSInput.color.a, 1.0, alphaFadeOut);
	}
#endif

}

